<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\LevelController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\BlacklistController;
use App\Http\Controllers\WhitelistController;
use App\Http\Controllers\VirtualServerController;
use App\Http\Controllers\buyerController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get("/date/current", function () {
    echo date("Y-m-d H:i:s");
});

Route::get("/date", function () {
    echo date("Y-m-d");
});

Route::get("/api/date", function () {
    echo date("Y-m-d");
});

Route::get("/api/date/current", function () {
    echo date("Y-m-d H:i:s");
});

Route::post("/basepath", function () {
    echo base_path();
});

Route::get("/api/gethost", function (Illuminate\Http\Request $request) {
    $host = $request->host;
    echo shell_exec("getent hosts " . $host . " | awk '{ print \$1 }' ");
});

Route::get("getserver", [ApiController::class, "getServer"])->name("getserver");

Route::get("/getip", function () {
    $v4mapped_prefix_hex = "00000000000000000000ffff";
    $v4mapped_prefix_bin = pack("H*", $v4mapped_prefix_hex);
    $addr = $_SERVER["REMOTE_ADDR"];
    $addr_bin = inet_pton($addr);
    if ($addr_bin === false) {
        exit("Invalid IP address");
    }
    if (substr($addr_bin, 0, strlen($v4mapped_prefix_bin)) == $v4mapped_prefix_bin) {
        $addr_bin = substr($addr_bin, strlen($v4mapped_prefix_bin));
    }
    $addr = inet_ntop($addr_bin);
    echo $addr;
})->name("getip");

Route::group(["prefix" => "admin", "middleware" => "notLogined"], function () {
    Route::get("/login", [FrontendController::class, "login"])->name("login");
    Route::post("/login", [FrontendController::class, "plogin"])->name("plogin");
});

Route::group(["prefix" => "admin", "middleware" => "logined"], function () {
    Route::get("/", [FrontendController::class, "home"])->name("home");
    Route::get("/profile", [FrontendController::class, "profile"])->name("profile");
    Route::post("/profile", [FrontendController::class, "post_profile"])->name("pprofile");
    Route::get("/logout", [FrontendController::class, "logout"])->name("logout");
    Route::get("/software", [FrontendController::class, "softwares"])->name("softwares");
    Route::get("/software/delete/{id}", [FrontendController::class, "software_delete"])->name("software.delete");
    Route::get("/software/add", [FrontendController::class, "software_add"])->name("software.add");
    Route::post("/software/add", [FrontendController::class, "software_addp"])->name("software.add");
    Route::get("/software/edit/{id}", [FrontendController::class, "software_edit"])->name("software.edit");
    Route::post("/software/edit/{id}", [FrontendController::class, "software_editp"])->name("software.edit");
    Route::post("/software/bulk_delete", [FrontendController::class, "bulk_software_delete"])->name("software.bulk_delete");
    Route::post("/software/bulk_activate", [FrontendController::class, "bulk_software_active"])->name("software.bulk_activate");
    Route::post("/software/bulk_disable", [FrontendController::class, "bulk_software_disabled"])->name("software.bulk_disable");
    Route::get("/level", [LevelController::class, "levels"])->name("levels");
    Route::get("/level/delete/{id}", [LevelController::class, "level_delete"])->name("level.delete");
    Route::get("/level/add", [LevelController::class, "level_add"])->name("level.add");
    Route::post("/level/add", [LevelController::class, "level_addp"])->name("level.add");
    Route::get("/level/edit/{id}", [LevelController::class, "level_edit"])->name("level.edit");
    Route::post("/level/edit/{id}", [LevelController::class, "level_editp"])->name("servleveler.edit");
    Route::post("/level/bulk_delete", [LevelController::class, "bulk_level_delete"])->name("level.bulk_delete");
    Route::get("/server", [FrontendController::class, "servers"])->name("servers");
    Route::get("/server/delete/{id}", [FrontendController::class, "server_delete"])->name("server.delete");
    Route::get("/server/add", [FrontendController::class, "server_add"])->name("server.add");
    Route::post("/server/add", [FrontendController::class, "server_addp"])->name("server.add");
    Route::get("/server/edit/{id}", [FrontendController::class, "server_edit"])->name("server.edit");
    Route::post("/server/edit/{id}", [FrontendController::class, "server_editp"])->name("server.edit");
    Route::post("/server/bulk_delete", [FrontendController::class, "bulk_server_delete"])->name("server.bulk_delete");
    Route::post("/server/bulk_activate", [FrontendController::class, "bulk_server_active"])->name("server.bulk_activate");
    Route::post("/server/bulk_disable", [FrontendController::class, "bulk_server_disabled"])->name("server.bulk_disable");
    Route::get("/proxy", [FrontendController::class, "proxies"])->name("proxies");
    Route::get("/proxy/delete/{id}", [FrontendController::class, "proxy_delete"])->name("proxy.delete");
    Route::get("/proxy/add", [FrontendController::class, "proxy_add"])->name("proxy.add");
    Route::post("/proxy/add", [FrontendController::class, "proxy_addp"])->name("proxy.add");
    Route::get("/proxy/edit/{id}", [FrontendController::class, "proxy_edit"])->name("proxy.edit");
    Route::post("/proxy/edit/{id}", [FrontendController::class, "proxy_editp"])->name("proxy.edit");
    Route::post("/proxy/bulk_delete", [FrontendController::class, "bulk_proxy_delete"])->name("proxy.bulk_delete");
    Route::post("/proxy/bulk_activate", [FrontendController::class, "bulk_proxy_active"])->name("proxy.bulk_activate");
    Route::post("/proxy/bulk_disable", [FrontendController::class, "bulk_proxy_disabled"])->name("proxy.bulk_disable");
    Route::get("/license", [FrontendController::class, "licenses"])->name("licenses");
    Route::get("/license/delete/{id}", [FrontendController::class, "license_delete"])->name("license.delete");
    Route::get("/license/add", [FrontendController::class, "license_add"])->name("license.add");
    Route::post("/license/add", [FrontendController::class, "license_addp"])->name("license.add");
    Route::get("/license/edit/{id}", [FrontendController::class, "license_edit"])->name("license.edit");
    Route::post("/license/edit/{id}", [FrontendController::class, "license_editp"])->name("license.edit");
    Route::post("/license/bulk_delete", [FrontendController::class, "bulk_license_delete"])->name("license.bulk_delete");
    Route::post("/license/bulk_activate", [FrontendController::class, "bulk_license_active"])->name("license.bulk_activate");
    Route::post("/license/bulk_disable", [FrontendController::class, "bulk_license_disabled"])->name("license.bulk_disable");
    Route::get("/reseller", [FrontendController::class, "resellers"])->name("resellers");
    Route::get("/reseller/delete/{id}", [FrontendController::class, "reseller_delete"])->name("reseller.delete");
    Route::get("/reseller/add", [FrontendController::class, "reseller_add"])->name("reseller.add");
    Route::post("/reseller/add", [FrontendController::class, "reseller_addp"])->name("reseller.add");
    Route::get("/reseller/edit/{id}", [FrontendController::class, "reseller_edit"])->name("reseller.edit");
    Route::post("/reseller/edit/{id}", [FrontendController::class, "reseller_editp"])->name("reseller.edit");
    Route::post("/reseller/bulk_delete", [FrontendController::class, "bulk_reseller_delete"])->name("reseller.bulk_delete");
    Route::post("/reseller/bulk_activate", [FrontendController::class, "bulk_reseller_active"])->name("reseller.bulk_activate");
    Route::post("/reseller/bulk_disable", [FrontendController::class, "bulk_reseller_disabled"])->name("reseller.bulk_disable");
    Route::get("/reseller/getclients", [FrontendController::class, "getClients"])->name("getClients");
    Route::get("/message", [MessageController::class, "index"])->name("message.index");
    Route::post("/message", [MessageController::class, "update"])->name("message.update");
    Route::get("/settings", [SettingController::class, "view"])->name("setting.view");
    Route::post("/settings", [SettingController::class, "update"])->name("setting.update");
    Route::get("/api", [SettingController::class, "view_api"])->name("api.view");
    Route::post("/api", [SettingController::class, "update_api"])->name("api.update");
    Route::get("/blacklist", [BlacklistController::class, "view"])->name("blacklist");
    Route::get("/blacklist/delete/{id}", [BlacklistController::class, "delete"])->name("blacklist.delete");
    Route::get("/blacklist/add", [BlacklistController::class, "add"])->name("blacklist.add");
    Route::post("/blacklist/add", [BlacklistController::class, "addp"])->name("blacklist.add");
    Route::get("/blacklist/edit/{id}", [BlacklistController::class, "edit"])->name("blacklist.edit");
    Route::post("/blacklist/edit/{id}", [BlacklistController::class, "editp"])->name("blacklist.edit");
    Route::post("/blacklist/bulk_delete", [BlacklistController::class, "bulk_delete"])->name("blacklist.bulk_delete");
    Route::post("/blacklist/bulk_activate", [BlacklistController::class, "bulk_active"])->name("blacklist.bulk_activate");
    Route::post("/blacklist/bulk_disable", [BlacklistController::class, "bulk_disabled"])->name("blacklist.bulk_disable");
    Route::get("/whitelist", [WhitelistController::class, "view"])->name("whitelist");
    Route::get("/whitelist/delete/{id}", [WhitelistController::class, "delete"])->name("whitelist.delete");
    Route::get("/whitelist/add", [WhitelistController::class, "add"])->name("whitelist.add");
    Route::post("/whitelist/add", [WhitelistController::class, "addp"])->name("whitelist.add");
    Route::get("/whitelist/edit/{id}", [WhitelistController::class, "edit"])->name("whitelist.edit");
    Route::post("/whitelist/edit/{id}", [WhitelistController::class, "editp"])->name("whitelist.edit");
    Route::post("/whitelist/bulk_delete", [WhitelistController::class, "bulk_delete"])->name("whitelist.bulk_delete");
    Route::post("/whitelist/bulk_activate", [WhitelistController::class, "bulk_active"])->name("whitelist.bulk_activate");
    Route::post("/whitelist/bulk_disable", [WhitelistController::class, "bulk_disabled"])->name("whitelist.bulk_disable");
    Route::get("/virtualserver", [VirtualServerController::class, "view"])->name("virtualserver");
    Route::get("/virtualserver/delete/{id}", [VirtualServerController::class, "delete"])->name("virtualserver.delete");
    Route::get("/virtualserver/add", [VirtualServerController::class, "add"])->name("virtualserver.add");
    Route::post("/virtualserver/add", [VirtualServerController::class, "addp"])->name("virtualserver.add");
    Route::get("/virtualserver/edit/{id}", [VirtualServerController::class, "edit"])->name("virtualserver.edit");
    Route::post("/virtualserver/edit/{id}", [VirtualServerController::class, "editp"])->name("virtualserver.edit");
    Route::post("/virtualserver/bulk_delete", [VirtualServerController::class, "bulk_delete"])->name("virtualserver.bulk_delete");
    Route::post("/virtualserver/bulk_activate", [VirtualServerController::class, "bulk_active"])->name("virtualserver.bulk_activate");
    Route::post("/virtualserver/bulk_disable", [VirtualServerController::class, "bulk_disabled"])->name("virtualserver.bulk_disable");
    Route::get("/buyer", [buyerController::class, "view"])->name("buyer");
    Route::get("/buyer/delete/{id}", [buyerController::class, "delete"])->name("buyer.delete");
    Route::get("/buyer/add", [buyerController::class, "add"])->name("buyer.add");
    Route::post("/buyer/add", [buyerController::class, "addp"])->name("buyer.add");
    Route::get("/buyer/edit/{id}", [buyerController::class, "edit"])->name("buyer.edit");
    Route::post("/buyer/edit/{id}", [buyerController::class, "editp"])->name("buyer.edit");
    Route::post("/buyer/bulk_delete", [buyerController::class, "bulk_delete"])->name("buyer.bulk_delete");
    Route::post("/buyer/bulk_activate", [buyerController::class, "bulk_active"])->name("buyer.bulk_activate");
    Route::post("/buyer/bulk_disable", [buyerController::class, "bulk_disabled"])->name("buyer.bulk_disable");
});

Route::group(["prefix" => "api", "middleware" => "checkWhmcs"], function () {
    Route::any("/whmcs/verify", [ApiController::class, "whmcs"])->middleware("apichecker")->name("whmcs");
});

Route::group(["prefix" => "api", "middleware" => "checkLicense"], function () {
    Route::get("/getinfo", [ApiController::class, "getInfo"])->name("apiInfo");
    Route::get("/license", [ApiController::class, "license"])->name("apiLicense");
    Route::get("/change", [ApiController::class, "change"])->name("apiChange");
    Route::get("/change1", [ApiController::class, "change1"])->name("apiChange1");
    Route::get("/change2", [ApiController::class, "change2"])->name("apiChange2");
    Route::get("/change3", [ApiController::class, "change3"])->name("apiChange3");
	Route::get("/getip", [ApiController::class, "get_ip"])->name("get_ip");
	Route::get("/sitepad", [ApiController::class, "sitepad"])->name("sitepad");
    Route::get("/softaculous", [ApiController::class, "softaculous"])->name("softaculous");
    Route::get("/virtualizor", [ApiController::class, "virtualizor"])->name("virtualizor");
    Route::get("/{key}/getlicense", [ApiController::class, "getLicenseHash"])->name("EncodeLicense");
    Route::get("/files/{folder}/{file?}", [ApiController::class, "files"])->name("getfiles")->where("file", "(.*)");
    Route::get("/gbv2/{folder}/{file?}", [ApiController::class, "gbv2"])->name("gbv2")->where("file", "(.*)");
	Route::get("/{key}/vultr", [ApiController::class, "vultr"])->name("vultr");
	Route::get("/{key}/license360", [ApiController::class, "imunify"])->name("imunify");
	Route::get("/{key}/license360", [ApiController::class, "imunify360"])->name("imunify360");
});

Route::get("/api/verifylicense", [ApiController::class, "verifyLicense"])->name("verifylicense");

Route::get("/api/data/{file}", [ApiController::class, "data"])->name("getdata");

Route::group(["prefix" => "resellerapi", "middleware" => "checkReseller"], function () {
    Route::get("/getlist", [ApiController::class, "getlist"])->name("getblanace");
    Route::get("/register", [ApiController::class, "registerLicense"])->name("registerlicense");
    Route::get("/licenseinfo", [ApiController::class, "getResellerLicenseInfo"])->middleware("checkResellerLicense")->name("getresellerlicenseinfo");
    Route::get("/getblanace", [ApiController::class, "getBlanace"])->name("getblanace");
    Route::get("/activate", [ApiController::class, "activateLicense"])->middleware("checkResellerLicense")->name("activatelicense");
    Route::get("/deactivate", [ApiController::class, "deactivateLicense"])->middleware("checkResellerLicense")->name("deactivatelicense");
    Route::get("/changeiplicense", [ApiController::class, "changeIpLicense"])->middleware("checkResellerLicense")->name("changeiplicense");
    Route::get("/delete", [ApiController::class, "deleteLicense"])->middleware("checkResellerLicense")->name("deletelicense");
});

Route::group(["prefix" => "api/reseller", "middleware" => "apichecker"], function () {
    Route::get("/getplans", [ApiController::class, "getplans"])->name("getplans");
    Route::get("/addbalance", [ApiController::class, "addBalance"])->name("addBalance");
    Route::get("/register", [ApiController::class, "registerReseller"])->name("registerreseller");
    Route::get("/info", [ApiController::class, "getResellerInfo"])->name("getresellerinfo");
    Route::get("/activate", [ApiController::class, "activateReseller"])->name("activatereseller");
    Route::get("/deactivate", [ApiController::class, "deactivateReseller"])->name("deactivatereseller");
    Route::get("/delete", [ApiController::class, "deleteReseller"])->name("deletereseller");
    Route::get("/getbuyers", [ApiController::class, "getbuyers"])->name("getbuyers");
});

Route::group(["prefix" => "resellerapi", "middleware" => "globalReseller"], function () {
    Route::get("/getmsg", [ApiController::class, "getmsg"])->name("getmsg");
    Route::get("/getstatus", [ApiController::class, "getstatus"])->name("getstatus");
    Route::get("/getpackage", [ApiController::class, "getpackage"])->name("getpackage");
    Route::get("/getsoftwares", [ApiController::class, "getsoftwares"])->name("getsoftwares");
});

?>