#!/bin/sh

confpath=/usr/local/lsws/conf

function rm_ea4_lsphps_t(){
      rm -rf $confpath/ea4_lsphps_t
}

function rm_ea4_handlers_t(){
    rm -rf $confpath/ea4_handlers_t
}

#main conversion script
EA4_EXTERNAL_PROC_TEMPLATE="${confpath}/ea4_lsphps_t"
EA4_HANDLER_TEMPLATE="${confpath}/ea4_handlers_t"

#Check for and add any missing LSPHP configurations 
if ! grep -q '<name>lsphp54</name>' $confpath/httpd_config.xml
then

    echo "    <extProcessor>
      <type>lsapi</type>
      <name>lsphp54</name>
      <address>uds://tmp/lshttpd/lsphp54.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php54/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi

if ! grep -q '<name>lsphp55</name>' $confpath/httpd_config.xml
then
    
    echo "    <extProcessor>
      <type>lsapi</type>
      <name>lsphp55</name>
      <address>uds://tmp/lshttpd/lsphp55.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php55/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi

if ! grep -q '<name>lsphp56</name>' $confpath/httpd_config.xml 
then
    
    echo "    <extProcessor>
     <type>lsapi</type>
      <name>lsphp56</name>
      <address>uds://tmp/lshttpd/lsphp56.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php56/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi

if ! grep -q '<name>lsphp70</name>' $confpath/httpd_config.xml
then
    
    echo "    <extProcessor>
      <type>lsapi</type>
      <name>lsphp70</name>
      <address>uds://tmp/lshttpd/lsphp70.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php70/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi

if ! grep -q '<name>lsphp71</name>' $confpath/httpd_config.xml
then
    
    echo "    <extProcessor>
      <type>lsapi</type>
      <name>lsphp71</name>
      <address>uds://tmp/lshttpd/lsphp71.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php71/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi

if ! grep -q '<name>lsphp72</name>' $confpath/httpd_config.xml
then
    
    echo "    <extProcessor>
      <type>lsapi</type>
      <name>lsphp72</name>
      <address>uds://tmp/lshttpd/lsphp72.sock</address>
      <note></note>
      <maxConns>35</maxConns>
      <env>PHP_LSAPI_MAX_REQUESTS=5000</env>
      <env>PHP_LSAPI_CHILDREN=35</env>
      <initTimeout>60</initTimeout>
      <retryTimeout>0</retryTimeout>
      <persistConn>1</persistConn>
      <pcKeepAliveTimeout></pcKeepAliveTimeout>
      <respBuffer>0</respBuffer>
      <autoStart>1</autoStart>
      <path>/opt/cpanel/ea-php72/root/usr/bin/lsphp</path>
      <backlog>100</backlog>
      <instances>1</instances>
      <runOnStartUp></runOnStartUp>
      <extMaxIdleTime>10</extMaxIdleTime>
      <priority>0</priority>
      <memSoftLimit>2047M</memSoftLimit>
      <memHardLimit>2047M</memHardLimit>
      <procSoftLimit>400</procSoftLimit>
      <procHardLimit>500</procHardLimit>
    </extProcessor>" >> $EA4_EXTERNAL_PROC_TEMPLATE

fi


if ! grep -q '<suffix>php54</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php54</suffix>
      <type>lsapi</type>
      <handler>lsphp54</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE

fi

if ! grep -q '<suffix>php55</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php55</suffix>
      <type>lsapi</type>
      <handler>lsphp55</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE

fi

if ! grep -q '<suffix>php56</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php56</suffix>
      <type>lsapi</type>
      <handler>lsphp56</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE

fi

if ! grep -q '<suffix>php70</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php70</suffix>
      <type>lsapi</type>
      <handler>lsphp70</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE
    
fi

if ! grep -q '<suffix>php71</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php71</suffix>
      <type>lsapi</type>
      <handler>lsphp71</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE
    
fi

if ! grep -q '<suffix>php72</suffix>' $confpath/httpd_config.xml
then
    echo "    <scriptHandler>
      <suffix>php72</suffix>
      <type>lsapi</type>
      <handler>lsphp72</handler>
      <note></note>
    </scriptHandler>" >> $EA4_HANDLER_TEMPLATE
    
fi

#Create a backup of current configuration file and add missing LSPHP configurations. Restart the server to have changes take affect.
now=$(date +"%Y%m%d")
yes | cp -p $confpath/httpd_config.xml $confpath/httpd_config.xml.ea3.$now
sed -i "/<extProcessorList>/r $confpath/ea4_lsphps_t" $confpath/httpd_config.xml  
sed -i "/<scriptHandlerList>/r $confpath/ea4_handlers_t" $confpath/httpd_config.xml
rm_ea4_lsphps_t
rm_ea4_handlers_t
service lsws restart
touch /usr/local/cpanel/whostmgr/docroot/cgi/lsws/litespeed_ea4
exit 0
