import os
import sys
import dataparse
def get_vhost_data_from_file():
    userdata_file="/etc/userdatadomains"
    if os.path.exists(userdata_file):
        ipv6data=dataparse.ipv6_get_user()
        userdata={}
        with open(userdata_file, 'r') as ufile:
            lines=ufile.read().splitlines()
        for line in lines:
            domd=line.split(' ')
            doms=domd[0].split(':')
            domain=doms[0]
            ds=domd[1].split('=')
            domainuser=ds[0]
            domaintype=ds[4]
            domainreal=ds[6]
            domaindocroot=ds[8]
            domainip=ds[10].split(':')[0].strip()
            if  domainuser not  in ipv6data.keys():
                ipv6='::'
                ipvstatus='0'
            elif bool(ipv6data) and bool(ipv6data[domainuser]):
                ipv6=ipv6data[domainuser]
                ipvstatus='1'
            else:
                ipv6='::'
                ipvstatus='0'
            userdata[domain]=[domain,domainuser,domaintype,domainreal,domaindocroot,domainip,ipvstatus,ipv6]
    else:
        userdata={}
    return userdata
