import os 
import sys
import shutil
import subprocess

def install_rule(vendor):
    if vendor == "owasp":
        print("""..................................................
                
Cpnginx OWASP ModSecurity Core Rule Set Installation
                
....................................................""")
        if os.path.exists("/usr/local/nginx/conf/conf.d/modsecurity.conf"):
            print("ModSecurity not installed with nginx. Please install it using #nginxctl")
            if not os.path.exists("/usr/local/cpanel/3rdparty/bin/git"):
                print("Cpanel Git nor found .. /usr/local/cpanel/3rdparty/bin/git")
                print("Installation failed")
            else:
                print("Installing OWASP ModSecurity Core Rule Set")
                src='/opt/cpnginx/src'
                dest='/usr/local/nginx/conf/modsecurity.rules/owasp';
                gitcmd='/usr/local/cpanel/3rdparty/bin/git'
                if not os.path.exists(src):
                    os.makedirs(src)
                if not os.path.exists(dest):
                    os.makedirs(dest)
                spath='/opt/cpnginx/src/coreruleset'
                if os.path.exists(spath):
                    shutil.rmtree(spath)
                owasppath=src+'/coreruleset'
                download=gitcmd+' clone https://github.com/coreruleset/coreruleset.git '+owasppath
                print("Downloading : "+download)
                subprocess.call(download, shell=True)
                if os.path.exists(owasppath):
                    crssetup='/opt/cpnginx/src/coreruleset/crs-setup.conf.example'
                    crssetupconf='/usr/local/nginx/conf/modsecurity.rules/crs-setup.conf'
                    owaspconf='/usr/local/nginx/conf/conf.d/owscp.conf'
                    if os.path.exists(crssetup):
                        shutil.copy(crssetup,crssetupconf)
                        copyconf='cp -rf '+owasppath+'/rules/* '+dest+'/'
                        subprocess.call(copyconf,shell=True)
                        with open(crssetupconf, "a") as fo:
                            fo.write("Include  /usr/local/nginx/conf/modsecurity.rules/owasp/*.conf")
                        with open(owaspconf, "w") as fd:
                            fd.write("modsecurity_rules_file  /usr/local/nginx/conf/modsecurity.rules/crs-setup.conf;")
                        print("Reloading nginx ... ",end=" ")
                        reloadcmd='/usr/local/nginx/sbin/nginx -s reload'
                        subprocess.call(reloadcmd,shell=True)
                        print ("done")
                        print("OWASP ModSecurity Core Rule Set installation completed")
                    else:
                        print ("Nor crs-setup.conf file on "+owasppath)
                        print ("Modsecurity rule installation failed.")
                else:
                    print ("Unable to download OWASP ModSecurity Core Rule Set from https://github.com/coreruleset/coreruleset.git")
                    print ("Modsecurity rule installation failed.")
        else:
            print("ModSecurity not installed with nginx. Please install it using #nginxctl")
    else:
        print ("Unsupported modsecurity rule vendor")

def remove_rule(vendor):
    if vendor == "owasp":
        owaspconf='/usr/local/nginx/conf/conf.d/owscp.conf'
        crssetupconf='/usr/local/nginx/conf/modsecurity.rules/crs-setup.conf'
        owaspdir='/usr/local/nginx/conf/modsecurity.rules/owasp'
        print("Uninstalling OWASP ModSecurity Core Rule Set , if installed")
        if os.path.exists(owaspconf):
            os.unlink(owaspconf)
        if os.path.exists(crssetupconf):
            os.unlink(crssetupconf)
        if os.path.exists(owaspdir):
            shutil.rmtree(owaspdir)
        print ("Removed OWASP nginx configurations")
        print ("Reloading nginx ... ",end=" ")
        reloadcmd='/usr/local/nginx/sbin/nginx -s reload'
        subprocess.call(reloadcmd,shell=True)
        print ("done")
        print ("Uninstallation completed")
    else:
        print("Unable to find the modsecurity vendor")
